/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.manageconns;

import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rcs.PathManager;
import com.ibm.hwmca.fw.rcs.PathQueueListener;
import com.ibm.hwmca.fw.rcs.manageconns.RcsConnectionsBean;
import com.ibm.hwmca.fw.rcs.manageconns.RcsConnectionsConstants;
import com.ibm.hwmca.fw.rcs.manageconns.RcsPathInfo;
import com.ibm.hwmca.fw.rcs.path.PathCancelReason;
import com.ibm.hwmca.fw.rcs.path.PathIdentifier;
import com.ibm.hwmca.fw.rcs.path.PathPriority;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class RcsConnectionsTasklet
extends PanelTasklet
implements RcsConnectionsConstants,
PathQueueListener {
    private static final String TRACE_MASKT = "XRCSCNTT";
    private static final String TRACE_MASKF = "XRCSCNTF";
    private static final String TRACE_MASKD = "XRCSCNTD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-ConnTskl");
    private String taskletRequestId = this.toString();
    private int taskletRequestNum = 0;
    private RcsConnectionsBean connectionsBean;
    private List activeReqInfo = new ArrayList();
    private List waitingReqInfo = new ArrayList();
    private Object requestInfoLock = new Object();

    public RcsConnectionsTasklet() {
        Trace.trace(TRACE_MASKT, "<> RcsConnectionsTasklet()");
    }

    public void init() throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> init()");
        Trace.trace(TRACE_MASKT, "<- init()");
    }

    public void destroy() {
        this.deregisterAsPathQueueListener();
        super.destroy();
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> service(" + request + ", " + response + ")");
        try {
            if (request.isInitialRequest()) {
                this.connectionsBean = new RcsConnectionsBean();
                this.connectionsBean.setBeanName("RcsConnectionsBean");
                this.registerAsPathQueueListener();
                response.replace("com.ibm.hwmca.fw.rcs.manageconns.res.RcsConnectionsRes", "RcsConnectionsPanel", this.connectionsBean);
            } else if (request.isDisposed() || request.isCanceled()) {
                response.terminate();
            } else {
                String source = (String)request.getData("Source");
                if (source == null) {
                    source = "";
                }
                Trace.trace(TRACE_MASKF, "source=" + source);
                if (source.equals("")) {
                    Trace.trace(TRACE_MASKF, "Unspecified source");
                    response.noAction();
                } else if (source.equals("RcsConnectionsPanel")) {
                    this.serviceRcsConnectionsPanel(request, response);
                } else {
                    Trace.trace(TRACE_MASKF, "Unknown source");
                    response.noAction();
                }
            }
        }
        catch (TaskletException te) {
            throw te;
        }
        catch (Exception e) {
            throw new TaskletException(e);
        }
        Trace.trace(TRACE_MASKT, "<- service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> logException(" + throwable + ")");
        new FrameworkLog(classLogInfo, 1940, throwable).log();
        Trace.trace(TRACE_MASKT, "<- logException()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceRcsConnectionsPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> serviceRcsConnectionsPanel()");
        String command = (String)request.getData("Command");
        if (command == null) {
            command = "";
        }
        Trace.trace(TRACE_MASKF, "command=" + command);
        if (command.equals("")) {
            Trace.trace(TRACE_MASKF, "Unspecified command");
            response.noAction();
        } else if (command.equals("UpdateRequestInfo")) {
            ArrayList waitingReqs;
            ArrayList activeReqs;
            Object object = this.requestInfoLock;
            synchronized (object) {
                activeReqs = new ArrayList(this.activeReqInfo);
                waitingReqs = new ArrayList(this.waitingReqInfo);
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("Command", command);
            data.put("RequestInfo", new List[]{activeReqs, waitingReqs});
            response.update("RcsConnectionsBean", data);
        } else if (command.equals("UpdateQueueStatus")) {
            LocalizableText statusDesc = null;
            boolean isOnHold = PathManager.getPathManager().isQueueOnHold();
            statusDesc = isOnHold ? new LocalizableText("com.ibm.hwmca.fw.rcs.manageconns.res.RcsConnectionsMsgs", "QUEUE_DISABLED") : new LocalizableText("com.ibm.hwmca.fw.rcs.manageconns.res.RcsConnectionsMsgs", "QUEUE_ENABLED");
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("Command", command);
            data.put("QueueEnablement", new Boolean(!isOnHold));
            data.put("QueueStatus", statusDesc);
            response.update("RcsConnectionsBean", data);
        } else if (command.equals("PrioritizeRequests")) {
            List rcsPathInfo = (List)request.getData("RequestInfo");
            this.cancelRcsPaths(rcsPathInfo, PathCancelReason.USER);
            response.noAction();
        } else if (command.equals("CancelRequests")) {
            List rcsPathInfo = (List)request.getData("RequestInfo");
            this.cancelRcsPaths(rcsPathInfo, PathCancelReason.USER);
            response.noAction();
        } else if (command.equals("HoldQueue")) {
            PathManager.getPathManager().setQueueOnHold(true);
            response.noAction();
        } else if (command.equals("ReleaseQueue")) {
            PathManager.getPathManager().setQueueOnHold(false);
            response.noAction();
        } else {
            Trace.trace(TRACE_MASKF, "Unknown command");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- serviceRcsConnectionsPanel()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAsPathQueueListener() {
        Object object = this.requestInfoLock;
        synchronized (object) {
            PathIdentifier pathId;
            List[] paths = PathManager.getPathManager().addPathQueueListener(this);
            Iterator active = paths[0].iterator();
            while (active.hasNext()) {
                pathId = (PathIdentifier)active.next();
                this.activeReqInfo.add(new RcsPathInfo(pathId));
            }
            Iterator waiting = paths[1].iterator();
            while (waiting.hasNext()) {
                pathId = (PathIdentifier)waiting.next();
                this.waitingReqInfo.add(new RcsPathInfo(pathId));
            }
        }
    }

    private void deregisterAsPathQueueListener() {
        PathManager.getPathManager().removePathQueueListener(this);
    }

    private void prioritizeRcsPaths(List prioritized) {
        PathManager pathMgr = PathManager.getPathManager();
        List paths = pathMgr.getQueuedPaths();
        Iterator pathInfos = prioritized.iterator();
        while (pathInfos.hasNext()) {
            RcsPathInfo pathInfo = (RcsPathInfo)pathInfos.next();
            String pathInfoId = pathInfo.getId();
            Trace.trace(TRACE_MASKF, "Prioritizing path " + pathInfoId);
            boolean found = false;
            Iterator pathIds = paths.iterator();
            while (pathIds.hasNext()) {
                PathIdentifier pathId = (PathIdentifier)pathIds.next();
                if (!pathId.getPathId().toString().equals(pathInfo.getId())) continue;
                try {
                    found = true;
                    pathMgr.setPriority(pathId, PathPriority.HIGH);
                }
                catch (IllegalArgumentException iae) {
                    Trace.trace(TRACE_MASKF, "Path not prioritized since it is no longer managed");
                }
                break;
            }
            if (found) continue;
            Trace.trace(TRACE_MASKF, "Path not prioritized since it is no longer managed");
        }
    }

    private void cancelRcsPaths(List canceled, PathCancelReason reason) {
        PathManager pathMgr = PathManager.getPathManager();
        List paths = pathMgr.getQueuedPaths();
        paths.addAll(pathMgr.getActivePaths());
        Iterator pathInfos = canceled.iterator();
        while (pathInfos.hasNext()) {
            RcsPathInfo pathInfo = (RcsPathInfo)pathInfos.next();
            String pathInfoId = pathInfo.getId();
            Trace.trace(TRACE_MASKF, "Canceling path " + pathInfoId);
            boolean found = false;
            Iterator pathIds = paths.iterator();
            while (pathIds.hasNext()) {
                PathIdentifier pathId = (PathIdentifier)pathIds.next();
                if (!pathId.getPathId().toString().equals(pathInfoId)) continue;
                try {
                    found = true;
                    pathMgr.cancelPath(pathId, reason);
                }
                catch (IllegalArgumentException iae) {
                    Trace.trace(TRACE_MASKF, "Path not canceled since it is no longer managed");
                }
                break;
            }
            if (found) continue;
            Trace.trace(TRACE_MASKF, "Path not canceled since it is no longer managed");
        }
    }

    private void updateRcsRequestInfo() {
        try {
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setSource(this.getUniqueTaskletRequestId());
            request.setData("Source", "RcsConnectionsPanel");
            request.setData("Command", "UpdateRequestInfo");
            this.postRequest("RcsConnectionsBean", request);
        }
        catch (TaskletException taskletException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getUniqueTaskletRequestId() {
        RcsConnectionsTasklet rcsConnectionsTasklet = this;
        synchronized (rcsConnectionsTasklet) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.taskletRequestId);
            sb.append("-");
            sb.append(++this.taskletRequestNum);
            return sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addedToWaiting(PathIdentifier pathId, int pos) {
        Trace.trace(TRACE_MASKT, "-> addedToWaiting(" + pathId.getPathId() + ", " + pos + ")");
        Object object = this.requestInfoLock;
        synchronized (object) {
            RcsPathInfo pathInfo = new RcsPathInfo(pathId);
            int index = this.waitingReqInfo.indexOf(pathInfo);
            if (index == -1) {
                this.waitingReqInfo.add(pathInfo);
            } else {
                this.waitingReqInfo.set(index, pathInfo);
            }
            this.updateRcsRequestInfo();
        }
        Trace.trace(TRACE_MASKT, "<- addedToWaiting()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reorderInWaiting(PathIdentifier pathId, int pos) {
        Trace.trace(TRACE_MASKT, "-> reorderInWaiting(" + pathId.getPathId() + "," + pos + ")");
        Object object = this.requestInfoLock;
        synchronized (object) {
            RcsPathInfo pathInfo = new RcsPathInfo(pathId);
            this.waitingReqInfo.remove(pathInfo);
            if (pos <= this.waitingReqInfo.size()) {
                this.waitingReqInfo.add(pos, pathInfo);
            } else {
                this.waitingReqInfo.add(pathInfo);
            }
            this.updateRcsRequestInfo();
        }
        Trace.trace(TRACE_MASKT, "<- reorderInWaiting()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedFromWaiting(PathIdentifier pathId) {
        Trace.trace(TRACE_MASKT, "-> removedFromWaiting(" + pathId.getPathId() + ")");
        Object object = this.requestInfoLock;
        synchronized (object) {
            if (this.waitingReqInfo.remove(new RcsPathInfo(pathId))) {
                this.updateRcsRequestInfo();
            }
        }
        Trace.trace(TRACE_MASKT, "<- removedFromWaiting()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveFromWaitingToActive(PathIdentifier pathId) {
        Trace.trace(TRACE_MASKT, "-> moveFromWaitingToActive(" + pathId.getPathId() + ")");
        Object object = this.requestInfoLock;
        synchronized (object) {
            RcsPathInfo pathInfo = new RcsPathInfo(pathId);
            this.waitingReqInfo.remove(pathInfo);
            int index = this.activeReqInfo.indexOf(pathInfo);
            if (index == -1) {
                this.activeReqInfo.add(pathInfo);
            } else {
                this.activeReqInfo.set(index, pathInfo);
            }
            this.updateRcsRequestInfo();
        }
        Trace.trace(TRACE_MASKT, "<- moveFromWaitingToActive()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removedFromActive(PathIdentifier pathId) {
        Trace.trace(TRACE_MASKT, "-> removedFromActive(" + pathId.getPathId() + ")");
        Object object = this.requestInfoLock;
        synchronized (object) {
            if (this.activeReqInfo.remove(new RcsPathInfo(pathId))) {
                this.updateRcsRequestInfo();
            }
        }
        Trace.trace(TRACE_MASKT, "<- removedFromActive()");
    }

    public void queueStateChanged(boolean onHold) {
        try {
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("Source", "RcsConnectionsPanel");
            request.setData("Command", "UpdateQueueStatus");
            this.postRequest("RcsConnectionsBean", request);
        }
        catch (TaskletException taskletException) {
            // empty catch block
        }
    }
}

